#include <stdio.h>
#include <stdlib.h>
#include "BufferedFile.h"

int main()
{
	BufferedFile TestFile("Test file", B_READ_WRITE, 10);
	if(TestFile.InitCheck() == B_NO_ERROR)
	{
		bool ReadCorrectly = true;
		uint32 Buffer32[45];
		if(TestFile.ReadNumber(Buffer32,sizeof(*Buffer32),11) != 11)
			ReadCorrectly = false;
		uint32 Counter;
		for(Counter = 0; Counter < 11; Counter++)
			if(Buffer32[Counter] != Counter)
				ReadCorrectly = false;
		if(ReadCorrectly)
			printf("First block read successfully\n");
		else
			printf("First block read FAILED\n");
		bool WrittenCorrectly = true;
		for(Counter = 11; Counter < 45; Counter++)
			if(TestFile.WriteNumber(&Counter,sizeof(Counter),1) != 1)
				WrittenCorrectly = false;
		if(WrittenCorrectly)
			WrittenCorrectly = (TestFile.FlushBuffer() == B_NO_ERROR);
		if(WrittenCorrectly)
			printf("Block write was successful\n");
		else
			printf("Block write FAILED\n");
		if(TestFile.Seek(1,SEEK_SET) != 1)
			printf("Seek FAILED\n");
		if(TestFile.ReadNumber(Buffer32,sizeof(*Buffer32),45) != 45)
			ReadCorrectly = false;
		for(Counter = 0; Counter < 45; Counter++)
			if(Buffer32[Counter] != Counter)
				ReadCorrectly = false;
		if(ReadCorrectly)
			printf("First read/write block read successfully\n");
		else
			printf("First read/write block read FAILED\n");
		uint16 Buffer16[20];
		for(Counter = 0; Counter < 20; Counter++)
			if(TestFile.ReadNumber(&Buffer16[Counter],sizeof(*Buffer16),1) != 1)
				ReadCorrectly = false;
		for(Counter = 0; Counter < 20; Counter++)
			if(Buffer16[Counter] != Counter)
				ReadCorrectly = false;
		if(ReadCorrectly)
			printf("Second read block was read successfully - phase was maintained\n");
		else
			printf("Second read block was not read successfully - phase was LOST\n");
	}
	else
		printf("\"Test file\" could not be opened for read/write! Error = %08X\n"
			"Did you run DemoWrite first?\n",(int)TestFile.InitCheck());
}
